#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//The Determined SphereMod01.fsh   by derSchamane   
//https://www.shadertoy.com/view/styBW1
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.5 //0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//                  = The Determined Sphere =         
//                by Maximilian Knape ·∑>| 2022            
// -----------------------------------------------------------
// This work is licensed under a Creative Commons Attribution-
//        NonCommercial-ShareAlike 3.0 Unported License


//   = Raymarching =

#define MAX_STEPS 160
#define STEP_FAC 0.9
#define MAX_DIST 300.
#define MIN_DIST 20.

#define SURF_DIST .001
#define SURF_MUL 400.
#define SURF_EXP 1.8

//  = Postprocessing = 

#define GAMMA vec3(.4545)
#define GLOW_INT 0.18
#define PP_CONT 1.0
#define PP_VIGN 1.8
#define AO_OCC 0.2
#define AO_SCA 0.5

#define AA_ENAB false
#define AA_THRE .1

// = Scene Parameters =

#define SPH_SIZE 8.     //1..25
#define SPH_SPEED 13.   //5..50
#define TER_HEIGHT 3.   //1..5

// --------------------

//#define iTime iTime*1.0
#define PI 3.14159265358979
#define TAU PI*2.
#define S(x,y,t) smoothstep(x,y,t)
#define ROT(a) mat2(cos(a), sin(a), -sin(a), cos(a))
#define SLOPE sin(atan(1.,2.2))
#define TERSIZE 10000.

float tOffset = 0.;
float tang = 0.;


mat2 Rot(float a) //2D
{
    float s = sin(a);
    float c = cos(a);
    return mat2(c, -s, s, c);
}

#define Rot2D(p, a) p=cos(a)*p+sin(a)*vec2(p.y,-p.x)
vec3 Rot(vec3 p, vec3 r) //3D - las
{
    Rot2D(p.xz, r.y);
    Rot2D(p.yx, r.z);
    Rot2D(p.zy, r.x);
    return p;
}

float hash(float n) { return fract(sin(n)*43758.5453123); } //iq

float noise(in vec2 x) //iq
{
    vec2 p = floor(x);
    vec2 f = fract(x);

    f = f*f*(3.0-2.0*f);

    float n = p.x + p.y*57.0;
    float res = mix(mix(hash(n+  0.0), hash(n+  1.0), f.x),
                    mix(hash(n+ 57.0), hash(n+ 58.0), f.x), f.y);
    return res;
}

float noise(in vec3 x) //iq
{
    vec3 p = floor(x);
    vec3 f = fract(x);

    f = f*f*(3.0-2.0*f);

    float n = p.x + p.y*57.0 + 113.0*p.z;
    float res = mix(mix(mix(hash(n+  0.0), hash(n+  1.0), f.x),
                        mix(hash(n+ 57.0), hash(n+ 58.0), f.x), f.y),
                    mix(mix(hash(n+113.0), hash(n+114.0), f.x),
                        mix(hash(n+170.0), hash(n+171.0), f.x), f.y), f.z);
    return res;
}

float SdBoxFrame( vec3 p, vec3 b, float e ) //iq
{
       p = abs(p  )-b;
  vec3 q = abs(p+e)-e;

  return min(min(
      length(max(vec3(p.x,q.y,q.z),0.0))+min(max(p.x,max(q.y,q.z)),0.0),
      length(max(vec3(q.x,p.y,q.z),0.0))+min(max(q.x,max(p.y,q.z)),0.0)),
      length(max(vec3(q.x,q.y,p.z),0.0))+min(max(q.x,max(q.y,p.z)),0.0));
}

vec2 MirrorBox(in vec2 p, const float size) { return mod(abs(-mod(p - size, 4.*size) + 2.*size), 4.*size) - size; }

vec2 Dist(vec3 p) 
{       
    float d, t = iTime*SPH_SPEED + tOffset;
    
    //position
    vec2 coor = MirrorBox(p.xz - vec2(t), TERSIZE);
    float dis = length(p.xz) / MAX_DIST;
    
    //trail
    float depth = S(SPH_SIZE, 0., max(0., abs(p.x - p.z))) * step(-SPH_SIZE / 2.5, min(p.x, p.z));
    depth += min((length(p.xz + SPH_SIZE*.1) - SPH_SIZE*.9), 0.) * S(.8, 0., sqrt(depth));
    float height = min(-depth * SPH_SIZE / 20., SPH_SIZE/TER_HEIGHT);
    
    //terrain
    height += noise(coor / 100.) * 10.;
    height += noise(coor /  10.) *  1.;
    height += noise(coor /   1.) *  0.1 * max(-1., 1.-abs(depth));
    height += S(.2, .1, dis) * noise(MirrorBox(p.xz - vec2(t), 10.) * 10.) * .01 * max(-.5, 1.5-abs(depth));
    
    //heightmap
    d = max(p.y - height*TER_HEIGHT + SPH_SIZE*2., 0.) * SLOPE;
    
    //sphere height
    vec2 sCoor = MirrorBox(-vec2(t), TERSIZE);
    height  = noise(sCoor / 100.) * 10.;
    height += noise(sCoor / 10.) * 1.;
    height -= SPH_SIZE / 16.;
    
    //sphere
    vec3 pos = p - vec3(0., height*TER_HEIGHT - SPH_SIZE, 0.);
    float sphere = length(pos) - SPH_SIZE;
    
    //roll
    pos = Rot(pos, vec3(length(vec2(iTime*SPH_SPEED + tOffset)) / SPH_SIZE, -PI/4., 0.));
    
    //pattern
    const float ps = 2.;
    float pat = length((mod(pos,ps)/ps - .5));
    sphere -= pat * 0.1; 
    
    //color + material
    float col = sphere < d ? 2.1 + pat*2.0 : -1.95;
    d = min(sphere, d);

    /*
    //ancient ruins
    vec2 size = vec2(200.);
    p.xz = MirrorBox(coor, 200.);//mod(abs(-mod(coor, 4.*size) + 2.*size), 4.*size) - size/2.;
    p = Rot(p, PI*vec3(.015,-0.1,0.01));
    float box = SdBoxFrame(p-vec3(30., 30., 25.), vec3(130.), 10.);
    col = mix(0.7, col, step(d, box));
    d = min(box, d);
    */
   
    return vec2(d, col);
}

vec3 Normal(vec3 p) 
{
    vec2 e = vec2(.01, 0);
    return normalize(Dist(p).x - vec3(Dist(p-e.xyy).x, Dist(p-e.yxy).x,Dist(p-e.yyx).x));
}

vec3 RayMarch(vec3 ro, vec3 rd) 
{
    float col = 0.;
	float dO = MIN_DIST;
    int steps = 0;
    
    for(int i = 0; i < MAX_STEPS; i++) 
    {
        steps = i;
        
    	vec3 p = ro + rd*dO;
        vec2 dS = Dist(p);
        col = dS.y;
        dO += dS.x * mix(STEP_FAC, 1., dO/MAX_DIST);
        
        if (dO > MAX_DIST || dS.x < (SURF_DIST * (pow(dO/MAX_DIST, SURF_EXP)*SURF_MUL+1.))) break;
    }
    
    return vec3(dO, steps, col);
}

float SoftShadow(vec3 ro, vec3 lp, float k) //Shane
{
    const int maxIterationsShad = 24; 
    
    vec3 rd = lp - ro;

    float shade = 1.;
    float dist = .002;    
    float end = max(length(rd), .001);
    float stepDist = end / float(maxIterationsShad);
    
    rd /= end;

    for (int i = 0; i < maxIterationsShad; i++)
    {

        float h = Dist(ro + rd*dist).x;
        shade = min(shade, smoothstep(0., 1., k*h/dist));
        dist += clamp(h, .02, .25);
        
        if (h < .0 || dist > end) break;
    }

    return min(max(shade, 0.08) + .1, 1.); 
}


float GetLight(vec3 p, vec3 n, vec3 lP, vec3 rd , float shine) 
{
    vec3 l = normalize(lP - p);
    float dif = S(-0., 1., dot(n, l)*.5+.5) * max(1.-max(-shine, 0.), 0.);
    if (shine > 0.) dif = mix(dif+.2, dif*.1 + pow(max(dot(l, reflect(rd, n)), 0.), shine*20.), shine);
    return dif;
}

float CalcAO(const in vec3 p, const in vec3 n) //iq
{
    float occ = AO_OCC;
    float sca = AO_SCA;

    for( int i = 0; i < 5 ; i++ )
    {
        float h = .001 + .150 * float(i) / 4.0;
        float d = Dist(p + h * n).x;
        occ += (h - d) * sca;
        sca *= .95;
    }
    return S(.0, 1. , 1. - 1.5 * occ);    
}

vec3 R(vec2 uv, vec3 p, vec3 l, float z)
{
    vec3 f = normalize(l-p),
        r = normalize(cross(vec3(0,1,0), f)),
        u = cross(f,r),
        c = p+f*z,
        i = c + uv.x*r + uv.y*u,
        d = normalize(i-p);
    return d;
}

vec3 hsv2rgb_smooth( in vec3 c ) //iq
{
    vec3 rgb = clamp( abs(mod(c.x*6.+vec3(0.,4.,2.),6.)-3.0)-1., 0., 1.);
	rgb = rgb*rgb*(3.0-2.*rgb);
    
	return c.z * mix( vec3(1.0), rgb, c.y);
}

vec3 Palette(int index)
{
    switch (index)
    {
        case 0: return vec3(.5, .5, .5);
        case 1: return vec3(1., .72, .5);
        case 2: return vec3(.4, .6, 1.);
        case 3: return hsv2rgb_smooth(vec3(fract(iTime*TAU/420.+.62), .7, 1.));
        case 4: return vec3(1., 0.5, .2);
    }
    return vec3(0.);
}

void Render( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord-.5 * iResolution.xy) / iResolution.y;
	vec2 m = iMouse.xy / iResolution.xy;
    if (length(m) <= 0.) m = vec2(.5);

    //cam
    float t = iTime*SPH_SPEED + tOffset;
    float xos = -sin(iTime*TAU / 100.) * 20.;
    vec3 ro = vec3(xos, 30., -SPH_SIZE-40.);
    ro.yz *= Rot(min(1.5, (m.y+.3)*.3) * PI + PI*.5);
    ro.xz *= Rot(-m.x * TAU - PI);
    float height = noise(MirrorBox(vec2(-t), TERSIZE) / 100.) * 10. * TER_HEIGHT;
    ro.y += height + pow(1.-m.y, 2.) * SPH_SIZE * 8.;
    vec3 rd = R(uv, ro, vec3(xos, 5. + height, 0.), 1.);
    
    //light
    vec3 lPos = vec3(8, 6, -2) * 1000.;
    vec3 bg =  Palette(2) * .5;
    bg = min(bg + pow(1. / (1. + 3.*S(1., -1., dot(normalize(lPos), rd))), 4.)*vec3(1) * .3, 1.); //sky
    bg += pow(S(.999, 1., dot(normalize(lPos), rd)), 2.); //sun
    vec3 col = bg;
    
    //speed variation
    tang = mix((noise(MirrorBox(vec2(SPH_SIZE/1. - t), TERSIZE) / 100.) *10.*TER_HEIGHT) - height, tang, .85);
    tOffset = mix(tOffset - ((tang * SPH_SPEED*.9)), tOffset, 0.1 + SPH_SPEED/50.);
    
    vec3 rmd = RayMarch(ro, rd);    
    
    if(rmd.x < MAX_DIST) 
    {
        vec3 p = ro + rd * rmd.x;
        vec3 n = Normal(p);
        
        col = Palette(int(floor(abs(rmd.z))));
        col *= GetLight(p, n, lPos, rd, fract(rmd.z)*abs(rmd.z)/rmd.z);
        col *= SoftShadow(p + n*.05, lPos, 2.0);
        col *= CalcAO(p, n);
        col = mix(col, bg, pow(rmd.x / MAX_DIST, SURF_EXP));
    }
    
    col += rmd.y / float(MAX_STEPS) * GLOW_INT * sqrt(min(rmd.x, MAX_DIST) / MAX_DIST);
    
    fragColor = vec4(col,1.0);
}

vec4 PP(vec3 col, vec2 uv)
{
    //contrast
    col = mix(col, S(vec3(0.), vec3(1.), col), PP_CONT);    
    //ACES color
    col =  clamp((col * (2.51f * col + 0.03f)) / (col * (2.43f * col + 0.59f) + 0.14f), 0.0f, 1.0f);
    //Vignette
    col *= S(PP_VIGN,-PP_VIGN/5., dot(uv,uv)); 
    //gamma correction
    col = pow(col, GAMMA);
    
    return vec4(col, 1.);
}
#define O fragColor
#define U fragCoord
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    Render(O,U);
    
    if (AA_ENAB && fwidth(length(O)) > AA_THRE)
    {
        vec4 o;
        for (int k=0; k < 9; k+= k==3?2:1 )
          { Render(o,U+vec2(k%3-1,k/3-1)/3.); O += o; }
        O /= 9.;
        //O.r++; //Show sampled area
    }
    
    O = PP(vec3(O), (U-.5 * iResolution.xy) / iResolution.y);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

